/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.monitor;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.pa.PAActionCommand;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.monitor.PADiagnosticFile;
import filenet.vw.apps.taskman.pa.monitor.PAMonitorPropertyPanel;
import filenet.vw.apps.taskman.pa.monitor.PAMonitorThread;
import filenet.vw.apps.taskman.pa.monitor.PAStatisticsCollectionThread;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;

public class PAMonitorNode
extends VWTaskBaseNode {
    private PAMonitorPropertyPanel m_propertyPanel = null;
    private PANode m_parent = null;
    private PAMonitorThread m_monitorThread = null;
    private PAStatisticsCollectionThread m_statCollectionThread = null;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("pamonitor_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("pamonitor_16.gif");

    public PAMonitorNode(PANode parent) throws Exception {
        super(VWResource.SystemStatistics);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.m_parent = parent;
        this.m_propertyPanel = new PAMonitorPropertyPanel(parent);
        this.getContentPane().setPropertyPanel(this.m_propertyPanel, false, false);
        this.m_monitorThread = new PAMonitorThread(this.m_parent, this.m_propertyPanel);
        this.m_statCollectionThread = new PAStatisticsCollectionThread(this.m_parent);
    }

    public void refresh() {
        if (this.m_parent.isStarted()) {
            if (!this.m_monitorThread.isRunning()) {
                this.m_monitorThread.start();
            }
            if (!this.m_statCollectionThread.isRunning()) {
                this.m_statCollectionThread.start();
            }
        } else {
            this.m_monitorThread.stop();
            this.m_statCollectionThread.stop();
            this.m_propertyPanel.clearStatistics();
        }
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "pa_statistics.htm");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, PAActionCommand.RESET_STATISTICS) == 0) {
                this.resetStatistics();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.GENERATE_DIAGNOSTIC_FILE) == 0) {
                this.generateDiagnosticFile();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{PAActionCommand.RESET_STATISTICS, "Add Separator", PAActionCommand.GENERATE_DIAGNOSTIC_FILE, "Add Separator", PAActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (actionCMD.equals(PAActionCommand.RESET_STATISTICS)) {
            return this.m_parent.isStarted();
        }
        if (actionCMD.equals(PAActionCommand.GENERATE_DIAGNOSTIC_FILE)) {
            return this.m_parent.isStarted();
        }
        return true;
    }

    private void resetStatistics() throws Exception {
        this.m_parent.getPAAdministration().resetStatistics();
    }

    private void generateDiagnosticFile() throws Exception {
        PADiagnosticFile file = new PADiagnosticFile(this.m_parent);
        file.write();
    }
}

